> :information_source:
> - File a bug on our [issue tracker](https://github.com/u01jmg3/ics-parser/issues) (if there isn't one already).
>   - If your patch is going to be large it might be a good idea to get the discussion started early. We are happy to discuss it in a new issue beforehand.
> - Please follow the coding standards already adhered to in the file you're editing before committing
>   - This includes the use of *4 spaces* over tabs for indentation
>   - Trim all trailing whitespace
>   - Using single quotes (`'`) where possible
>   - Use `PHP_EOL` where possible or default to `\n`
>   - Using the [1TBS](https://en.wikipedia.org/wiki/Indent_style#Variant:_1TBS_.28OTBS.29) indent style
> - If a function is added or changed, please remember to update the [API documentation in the README](https://github.com/u01jmg3/ics-parser/blob/master/README.md#api)
> - Please include unit tests to verify any new functionality
>   - Also check that existing tests still pass: `composer test`
